<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Appointment;
use App\Models\Doctor;
use App\Models\Service;
use App\Models\ContactMessage;
use App\Models\Blog;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_doctors' => Doctor::count(),
            'active_doctors' => Doctor::where('is_active', true)->count(),
            'total_services' => Service::count(),
            'active_services' => Service::where('is_active', true)->count(),
            'pending_appointments' => Appointment::where('status', 'pending')->count(),
            'total_appointments' => Appointment::count(),
            'unread_messages' => ContactMessage::where('is_read', false)->count(),
            'total_blogs' => Blog::count(),
            'published_blogs' => Blog::where('is_published', true)->count(),
            'total_testimonials' => Testimonial::count(),
            'active_testimonials' => Testimonial::where('is_active', true)->count(),
        ];

        $recentAppointments = Appointment::with('doctor')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentAppointments'));
    }
}
